
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cherry_pies = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cherry_pies")
knishes = m.addVar(lb=0, vtype=GRB.INTEGER, name="knishes")
chicken_thighs = m.addVar(lb=0, vtype=GRB.INTEGER, name="chicken_thighs")
fruit_salads = m.addVar(lb=0, vtype=GRB.INTEGER, name="fruit_salads")
bowls_of_instant_ramen = m.addVar(lb=0, vtype=GRB.INTEGER, name="bowls_of_instant_ramen")
hot_dogs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hot_dogs")


# Set objective function
m.setObjective(4*cherry_pies**2 + 4*cherry_pies*knishes + 9*knishes**2 + 8*knishes*fruit_salads + 3*knishes*bowls_of_instant_ramen + 8*knishes*hot_dogs + 9*chicken_thighs**2 + 1*chicken_thighs*fruit_salads + 6*fruit_salads*bowls_of_instant_ramen + 2*hot_dogs**2 + 4*cherry_pies + 5*knishes + 4*chicken_thighs + 8*hot_dogs, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*knishes + 4*hot_dogs >= 3)
m.addConstr(5*cherry_pies + 5*knishes >= 2)
m.addConstr(5*cherry_pies + 4*bowls_of_instant_ramen + 4*hot_dogs >= 7)
m.addConstr(5*knishes + 3*chicken_thighs + 5*fruit_salads >= 7)
m.addConstr(5*cherry_pies + 5*knishes + 3*chicken_thighs >= 7)
m.addConstr(25*cherry_pies**2 + 25*knishes**2 + 16*hot_dogs**2 >= 7)
m.addConstr(5*cherry_pies + 5*knishes + 4*bowls_of_instant_ramen >= 7)
m.addConstr(3*chicken_thighs + 5*fruit_salads + 4*bowls_of_instant_ramen >= 7)
m.addConstr(5*cherry_pies + 5*fruit_salads + 4*hot_dogs >= 7)
m.addConstr(25*fruit_salads**2 + 16*bowls_of_instant_ramen**2 + 16*hot_dogs**2 >= 7)
m.addConstr(25*knishes**2 + 25*fruit_salads**2 + 16*hot_dogs**2 >= 7)
m.addConstr(9*chicken_thighs**2 + 16*bowls_of_instant_ramen**2 + 16*hot_dogs**2 >= 7)
m.addConstr(-9*cherry_pies + 7*hot_dogs >= 0)
m.addConstr(-7*chicken_thighs + 10*bowls_of_instant_ramen >= 0)
m.addConstr(8*cherry_pies - 9*bowls_of_instant_ramen >= 0)
m.addConstr(-7*fruit_salads + 6*bowls_of_instant_ramen >= 0)
m.addConstr(5 * knishes + 5 * fruit_salads + 4 * hot_dogs <= 21)
m.addConstr(5*cherry_pies + 5*knishes + 3*chicken_thighs + 5*fruit_salads + 4*bowls_of_instant_ramen + 4*hot_dogs <= 51)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

