
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="cherry_pies", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="knishes", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="chicken_thighs", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="fruit_salads", vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="bowls_of_instant_ramen", vtype=gurobi.GRB.INTEGER)
    x6 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hot_dogs", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(4*x1**2 + 4*x1*x2 + 9*x2**2 + 8*x2*x4 + 3*x2*x5 + 8*x2*x6 + 9*x3**2 + x3*x4 + 6*x4*x5 + 2*x6**2 + 4*x1 + 5*x2 + 4*x3 + 8*x6, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5*x1 + 5*x2 + 3*x3 + 5*x4 + 4*x5 + 4*x6 <= 51)
    model.addConstr(5*x2 + 4*x6 >= 3)
    model.addConstr(5*x1 + 5*x2 >= 2)
    model.addConstr(5*x1 + 4*x5 + 4*x6 >= 7)
    model.addConstr(5*x2 + 3*x3 + 5*x4 >= 7)
    model.addConstr(5*x1 + 5*x2 + 3*x3 >= 7)
    model.addConstr(5*x1**2 + 5*x2**2 + 4*x6**2 >= 7)
    model.addConstr(5*x1 + 5*x2 + 4*x5 >= 7)
    model.addConstr(3*x3 + 5*x4 + 4*x5 >= 7)
    model.addConstr(5*x1 + 5*x4 + 4*x6 >= 7)
    model.addConstr(5*x4**2 + 4*x5**2 + 4*x6**2 >= 7)
    model.addConstr(5*x2**2 + 5*x4**2 + 4*x6**2 >= 7)
    model.addConstr(9*x3**2 + 4*x5**2 + 4*x6**2 >= 7)
    model.addConstr(5*x1 + 4*x5 + 4*x6 >= 7)
    model.addConstr(5*x2 + 3*x3 + 5*x4 >= 7)
    model.addConstr(5*x1**2 + 5*x2**2 + 9*x3**2 >= 7)
    model.addConstr(5*x1 + 5*x2 + 4*x6 >= 7)
    model.addConstr(5*x1 + 5*x2 + 4*x5 >= 7)
    model.addConstr(9*x3**2 + 5*x4**2 + 4*x5**2 >= 7)
    model.addConstr(5*x1**2 + 5*x4**2 + 4*x6**2 >= 7)
    model.addConstr(5*x4 + 4*x5 + 4*x6 >= 7)
    model.addConstr(5*x2 + 5*x4 + 4*x6 >= 7)
    model.addConstr(9*x3**2 + 4*x5**2 + 4*x6**2 >= 8)
    model.addConstr(-9*x1 + 7*x6 >= 0)
    model.addConstr(-7*x3 + 10*x5 >= 0)
    model.addConstr(8*x1 - 9*x5 >= 0)
    model.addConstr(-7*x4 + 6*x5 >= 0)
    model.addConstr(5*x2 + 5*x4 + 4*x6 <= 21)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
        print("x6: ", x6.varValue)
    else:
        print("No optimal solution found.")

optimization_problem()
