
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B9
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of magnesium
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of calcium


    # Set objective function
    m.setObjective(8*x0 + 7*x1 + 7*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(9*x0 + 12*x2 >= 35, "c0")
    m.addConstr(9*x0 + 13*x1 + 12*x2 >= 56, "c1")
    m.addConstr(5*x0 + 17*x2 >= 112, "c2")
    m.addConstr(23*x1 + 17*x2 >= 79, "c3")
    m.addConstr(5*x0 + 23*x1 >= 112, "c4")
    m.addConstr(5*x0 + 23*x1 + 17*x2 >= 112, "c5")
    m.addConstr(-3*x1 + 8*x2 >= 0, "c6")
    m.addConstr(-3*x0 + 10*x2 >= 0, "c7")
    m.addConstr(13*x1 + 12*x2 <= 213, "c8")
    m.addConstr(9*x0 + 12*x2 <= 104, "c9")
    m.addConstr(9*x0 + 13*x1 + 12*x2 <= 255, "c10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
