
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin B9
    x1 = model.addVar(name="x1", lb=0)  # milligrams of magnesium
    x2 = model.addVar(name="x2", lb=0)  # milligrams of calcium

    # Define the objective function
    model.setObjective(8 * x0 + 7 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * x0 <= 284)
    model.addConstr(5 * x0 <= 392)
    model.addConstr(13 * x1 <= 284)
    model.addConstr(23 * x1 <= 392)
    model.addConstr(12 * x2 <= 284)
    model.addConstr(17 * x2 <= 392)
    model.addConstr(9 * x0 + 12 * x2 >= 35)
    model.addConstr(9 * x0 + 13 * x1 + 12 * x2 >= 56)
    model.addConstr(5 * x0 + 17 * x2 >= 112)
    model.addConstr(23 * x1 + 17 * x2 >= 79)
    model.addConstr(5 * x0 + 23 * x1 >= 112)
    model.addConstr(5 * x0 + 23 * x1 + 17 * x2 >= 112)
    model.addConstr(-3 * x1 + 8 * x2 >= 0)
    model.addConstr(-3 * x0 + 10 * x2 >= 0)
    model.addConstr(13 * x1 + 12 * x2 <= 213)
    model.addConstr(9 * x0 + 12 * x2 <= 104)
    model.addConstr(9 * x0 + 13 * x1 + 12 * x2 <= 255)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B9: {x0.varValue}")
        print(f"Milligrams of magnesium: {x1.varValue}")
        print(f"Milligrams of calcium: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
