
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
oreos = m.addVar(lb=0, name="oreos")
ham_sandwiches = m.addVar(lb=0, name="ham_sandwiches")
chicken_drumsticks = m.addVar(lb=0, name="chicken_drumsticks")

# Set objective function
m.setObjective(9.79 * oreos + 6.05 * ham_sandwiches + 7.14 * chicken_drumsticks, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * ham_sandwiches + 8 * chicken_drumsticks >= 20, "iron_constraint1")
m.addConstr(10 * oreos + 8 * chicken_drumsticks >= 33, "iron_constraint2")
m.addConstr(2 * oreos + 3 * ham_sandwiches + 2 * chicken_drumsticks >= 40, "fat_constraint1")
m.addConstr(9 * oreos + 3 * chicken_drumsticks <= 102, "tastiness_constraint1")
m.addConstr(11 * ham_sandwiches + 3 * chicken_drumsticks <= 98, "tastiness_constraint2")
m.addConstr(9 * oreos + 11 * ham_sandwiches + 3 * chicken_drumsticks <= 67, "tastiness_constraint3")
m.addConstr(10 * oreos + 8 * chicken_drumsticks <= 90, "iron_constraint3")
m.addConstr(10 * oreos + 8 * ham_sandwiches + 8 * chicken_drumsticks <= 74, "iron_constraint4")
m.addConstr(9 * oreos + 8 * chicken_drumsticks <= 76, "umami_constraint1")
m.addConstr(10 * ham_sandwiches + 8 * chicken_drumsticks <= 74, "umami_constraint2")
m.addConstr(9 * oreos + 10 * ham_sandwiches + 8 * chicken_drumsticks <= 74, "umami_constraint3")
m.addConstr(2 * oreos + 3 * ham_sandwiches <= 67, "fat_constraint2")
m.addConstr(2 * oreos + 2 * chicken_drumsticks <= 101, "fat_constraint3")
m.addConstr(2 * oreos + 3 * ham_sandwiches + 2 * chicken_drumsticks <= 101, "fat_constraint4")
m.addConstr(8 * oreos + 11 * ham_sandwiches <= 58, "cost_constraint1")
m.addConstr(8 * oreos + 11 * ham_sandwiches + 3 * chicken_drumsticks <= 58, "cost_constraint2")


# Resource Constraints (provided in the problem description)
m.addConstr(9 * oreos <= 108, "r0_oreos")
m.addConstr(10 * oreos <= 104, "r1_oreos")
m.addConstr(9 * oreos <= 152, "r2_oreos")
m.addConstr(2 * oreos <= 134, "r3_oreos")
m.addConstr(8 * oreos <= 115, "r4_oreos")

m.addConstr(11 * ham_sandwiches <= 108, "r0_ham_sandwiches")
m.addConstr(8 * ham_sandwiches <= 104, "r1_ham_sandwiches")
m.addConstr(10 * ham_sandwiches <= 152, "r2_ham_sandwiches")
m.addConstr(3 * ham_sandwiches <= 134, "r3_ham_sandwiches")
m.addConstr(11 * ham_sandwiches <= 115, "r4_ham_sandwiches")

m.addConstr(3 * chicken_drumsticks <= 108, "r0_chicken_drumsticks")
m.addConstr(8 * chicken_drumsticks <= 104, "r1_chicken_drumsticks")
m.addConstr(8 * chicken_drumsticks <= 152, "r2_chicken_drumsticks")
m.addConstr(2 * chicken_drumsticks <= 134, "r3_chicken_drumsticks")
m.addConstr(3 * chicken_drumsticks <= 115, "r4_chicken_drumsticks")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('oreos:', oreos.x)
    print('ham_sandwiches:', ham_sandwiches.x)
    print('chicken_drumsticks:', chicken_drumsticks.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

