
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="oreos", lb=0)
    x1 = model.addVar(name="ham sandwiches", lb=0)
    x2 = model.addVar(name="chicken drumsticks", lb=0)

    # Objective function
    model.setObjective(9.79*x0 + 6.05*x1 + 7.14*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(9*x0 + 11*x1 + 3*x2 <= 108)
    model.addConstr(10*x0 + 8*x1 + 8*x2 <= 104)
    model.addConstr(9*x0 + 10*x1 + 8*x2 <= 152)
    model.addConstr(2*x0 + 3*x1 + 2*x2 <= 134)
    model.addConstr(8*x0 + 11*x1 + 3*x2 <= 115)
    model.addConstr(8*x1 + 8*x2 >= 20)
    model.addConstr(10*x0 + 8*x2 >= 33)
    model.addConstr(2*x0 + 3*x1 + 2*x2 >= 40)
    model.addConstr(9*x0 + 3*x2 <= 102)
    model.addConstr(11*x1 + 3*x2 <= 98)
    model.addConstr(9*x0 + 11*x1 + 3*x2 <= 67)
    model.addConstr(10*x0 + 8*x2 <= 90)
    model.addConstr(10*x0 + 8*x1 + 8*x2 <= 74)
    model.addConstr(9*x0 + 8*x2 <= 76)
    model.addConstr(10*x1 + 8*x2 <= 74)
    model.addConstr(9*x0 + 10*x1 + 8*x2 <= 74)
    model.addConstr(2*x0 + 3*x1 <= 67)
    model.addConstr(2*x0 + 2*x2 <= 101)
    model.addConstr(2*x0 + 3*x1 + 2*x2 <= 101)
    model.addConstr(8*x0 + 11*x1 <= 58)
    model.addConstr(8*x0 + 11*x1 + 3*x2 <= 58)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Oreos: ", x0.varValue)
        print("Ham sandwiches: ", x1.varValue)
        print("Chicken drumsticks: ", x2.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
