
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
    iron = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="iron")
    fiber = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="fiber")
    vit_A = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vit_A")
    vit_B6 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vit_B6")
    vit_B4 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vit_B4")


    # Set objective function
    m.setObjective(1.31*fat + 2.12*iron + 6.66*fiber + 9.2*vit_A + 1.93*vit_B6 + 6.97*vit_B4, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9*vit_A + 9*vit_B6 >= 44)
    m.addConstr(2*fat + 1*fiber + 9*vit_A >= 54)
    m.addConstr(2*fat + 3*iron <= 291)
    m.addConstr(3*iron + 1*fiber <= 96)
    m.addConstr(3*iron + 2*vit_B4 <= 282)
    m.addConstr(3*iron + 9*vit_A <= 234)
    m.addConstr(9*vit_A + 9*vit_B6 <= 97)
    m.addConstr(2*fat + 2*vit_B4 <= 235)
    m.addConstr(1*fiber + 2*vit_B4 <= 82)
    m.addConstr(9*vit_B6 + 2*vit_B4 <= 80)
    m.addConstr(2*fat + 1*fiber <= 337)
    m.addConstr(2*fat + 3*iron + 1*fiber + 9*vit_A + 9*vit_B6 + 2*vit_B4 <= 337)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
