
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # grams of fat
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x2")  # milligrams of iron
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x3")  # grams of fiber
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x4")  # milligrams of vitamin A
    x5 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x5")  # milligrams of vitamin B6
    x6 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x6")  # milligrams of vitamin B4

    # Objective function
    model.setObjective(1.31*x1 + 2.12*x2 + 6.66*x3 + 9.2*x4 + 1.93*x5 + 6.97*x6, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + 3*x2 + x3 + 9*x4 + 9*x5 + 2*x6 <= 344)
    model.addConstr(9*x4 + 9*x5 >= 44)
    model.addConstr(2*x1 + x3 + 9*x4 >= 54)
    model.addConstr(2*x1 + 3*x2 <= 291)
    model.addConstr(3*x2 + x3 <= 96)
    model.addConstr(3*x2 + 2*x6 <= 282)
    model.addConstr(3*x2 + 9*x4 <= 234)
    model.addConstr(9*x4 + 9*x5 <= 97)
    model.addConstr(2*x1 + 2*x6 <= 235)
    model.addConstr(x3 + 2*x6 <= 82)
    model.addConstr(9*x5 + 2*x6 <= 80)
    model.addConstr(2*x1 + x3 <= 337)
    model.addConstr(2*x1 + 3*x2 + x3 + 9*x4 + 9*x5 + 2*x6 <= 337)

    # Bounds
    model.addConstr(x1 >= 0)  # Assuming non-negative

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
        print("x6: ", x6.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
