
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_A")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_B1")
    x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_B2")


    # Set objective function
    m.setObjective(9.2*x0**2 + 3.11*x0*x1 + 3.0*x2**2 + 4.71*x1 + 2.77*x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10*x0 + 9*x1 + 4*x2 <= 139, "muscle_growth_limit")
    m.addConstr(4*x0 + 12*x1 + 8*x2 <= 52, "cognitive_performance_limit")
    m.addConstr(9*x1**2 + 4*x2**2 >= 46, "muscle_growth_B1_B2")
    m.addConstr(10*x0 + 4*x2 >= 27, "muscle_growth_A_B2")
    m.addConstr(10*x0 + 9*x1 >= 36, "muscle_growth_A_B1")
    m.addConstr(10*x0 + 9*x1 + 4*x2 >= 36, "muscle_growth_total")
    m.addConstr(4*x0 + 8*x2 >= 14, "cognitive_performance_A_B2")
    m.addConstr(12*x1 + 8*x2 >= 6, "cognitive_performance_B1_B2")
    m.addConstr(4*x0 + 12*x1 + 8*x2 >= 6, "cognitive_performance_total")
    m.addConstr(4*x0 - 4*x2 >= 0, "A_B2_relation")
    m.addConstr(4*x0 + 12*x1 <= 43, "cognitive_performance_A_B1_max")
    m.addConstr(4*x0 + 8*x2 <= 18, "cognitive_performance_A_B2_max")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
