
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x0 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")
x1 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")
x2 = m.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="x2", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(9.2*x0**2 + 3.11*x0*x1 + 3.0*x2**2 + 4.71*x1 + 2.77*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(x0 == 10, name="c1")
m.addConstr(4*x0 == 4, name="c2")
m.addConstr(9*x1 == 9, name="c3")
m.addConstr(12*x1 == 12, name="c4")
m.addConstr(4*x2 == 4, name="c5")
m.addConstr(8*x2 == 8, name="c6")
m.addConstr(9*x1**2 + 4*x2**2 >= 46, name="c7")
m.addConstr(10*x0 + 4*x2 >= 27, name="c8")
m.addConstr(10*x0 + 9*x1 >= 36, name="c9")
m.addConstr(10*x0 + 9*x1 + 4*x2 >= 36, name="c10")
m.addConstr(4*x0 + 8*x2 >= 14, name="c11")
m.addConstr(12*x1 + 8*x2 >= 6, name="c12")
m.addConstr(4*x0 + 12*x1 + 8*x2 >= 6, name="c13")
m.addConstr(4*x0 - 4*x2 >= 0, name="c14")
m.addConstr(4*x0 + 12*x1 <= 43, name="c15")
m.addConstr(4*x0 + 8*x2 <= 18, name="c16")

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("No solution found")
