
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("pizza_chicken_optimization")

# Create variables
slices_of_pizza = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="slices_of_pizza")
chicken_breasts = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_breasts")


# Set objective function
m.setObjective(4.05 * slices_of_pizza + 6.13 * chicken_breasts, GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * slices_of_pizza + 15 * chicken_breasts >= 101, "cost_lower_bound")
m.addConstr(18 * slices_of_pizza + 15 * chicken_breasts <= 177, "cost_upper_bound")
m.addConstr(8 * slices_of_pizza - 4 * chicken_breasts >= 0, "pizza_chicken_ratio")



# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution found:")
    print(f"Slices of pizza: {slices_of_pizza.x}")
    print(f"Chicken breasts: {chicken_breasts.x}")
    print(f"Objective value: {m.objVal}")

