
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(lb=0, name="slices_of_pizza")
x2 = m.addVar(lb=0, name="chicken_breasts")

# Set the objective function
m.setObjective(4.05*x1 + 6.13*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(18*x1 + 15*x2 >= 101, "minimum_cost")
m.addConstr(18*x1 + 15*x2 <= 177, "maximum_cost")
m.addConstr(8*x1 - 4*x2 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"slices_of_pizza: {x1.x}")
    print(f"chicken_breasts: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
