
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="slices_of_pizza", lb=0)  # slices of pizza
    x2 = model.addVar(name="chicken_breasts", lb=0)  # chicken breasts

    # Define the objective function
    model.setObjective(4.05 * x1 + 6.13 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(18 * x1 + 15 * x2 >= 101)
    model.addConstr(8 * x1 - 4 * x2 >= 0)
    model.addConstr(18 * x1 + 15 * x2 <= 177)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Slices of pizza: {x1.x}")
        print(f"Chicken breasts: {x2.x}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimize_problem()
