
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")  # hours worked by Laura
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")  # hours worked by George
    x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")  # hours worked by Paul


    # Set objective function
    model.setObjective(4*x0**2 + 8*x0*x1 + 2*x1*x2 + 2*x2**2 + 4*x2, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7*x0**2 + 3*x1**2 >= 24)
    model.addConstr(7*x0 + 3*x2 >= 23)
    model.addConstr(7*x0**2 + 3*x1**2 + 3*x2**2 >= 23)
    model.addConstr(7*x0 + 3*x1 + 3*x2 >= 23)
    model.addConstr(1*x0**2 + 10*x1**2 >= 19)
    model.addConstr(10*x1 + 9*x2 >= 26)
    model.addConstr(1*x0 + 10*x1 + 9*x2 >= 26)
    model.addConstr(7*x1 + 1*x2 >= 22)
    model.addConstr(9*x0**2 + 7*x1**2 >= 38)
    model.addConstr(9*x0 + 7*x1 + 1*x2 >= 34)
    model.addConstr(-7*x0**2 + 8*x1**2 >= 0)
    model.addConstr(7*x0 + 3*x1 <= 39)
    model.addConstr(7*x0**2 + 3*x1**2 + 3*x2**2 <= 64)
    model.addConstr(10*x1 + 9*x2 <= 43)
    model.addConstr(x0 + 10*x1 + 9*x2 <= 58)


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
