
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Laura')
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_George')
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Paul')

    # Define the objective function
    model.setObjective(4*x0**2 + 8*x0*x1 + 2*x1*x2 + 2*x2**2 + 4*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7*x0 <= 76)
    model.addConstr(1*x0 <= 82)
    model.addConstr(9*x0 <= 130)
    model.addConstr(3*x1 <= 76)
    model.addConstr(10*x1 <= 82)
    model.addConstr(7*x1 <= 130)
    model.addConstr(3*x2 <= 76)
    model.addConstr(9*x2 <= 82)
    model.addConstr(1*x2 <= 130)
    model.addConstr(7*x0**2 + 3*x1**2 >= 24)
    model.addConstr(7*x0 + 3*x2 >= 23)
    model.addConstr(7*x0**2 + 3*x1**2 + 3*x2**2 >= 23)
    model.addConstr(7*x0 + 3*x1 + 3*x2 >= 23)
    model.addConstr(1*x0**2 + 10*x1**2 >= 19)
    model.addConstr(10*x1 + 9*x2 >= 26)
    model.addConstr(1*x0 + 10*x1 + 9*x2 >= 26)
    model.addConstr(7*x1 + 1*x2 >= 22)
    model.addConstr(9*x0**2 + 7*x1**2 >= 38)
    model.addConstr(9*x0 + 7*x1 + 1*x2 >= 34)
    model.addConstr(9*x0 + 7*x1 + 1*x2 >= 34)
    model.addConstr(-7*x0**2 + 8*x1**2 >= 0)
    model.addConstr(7*x0 + 3*x1 <= 39)
    model.addConstr(7*x0**2 + 3*x1**2 + 3*x2**2 <= 64)
    model.addConstr(10*x1 + 9*x2 <= 43)
    model.addConstr(1*x0 + 10*x1 + 9*x2 <= 58)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Laura: ', x0.varValue)
        print('Hours worked by George: ', x1.varValue)
        print('Hours worked by Paul: ', x2.varValue)
    else:
        print('No optimal solution found')

optimize_problem()
