
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Hours_Worked")

# Create variables
laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
peggy_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peggy_hours")
jean_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")
mary_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="mary_hours")
dale_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="dale_hours")
bobby_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bobby_hours")
paul_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="paul_hours")


# Set objective function
model.setObjective(8.46 * laura_hours + 9.2 * peggy_hours + 3.03 * jean_hours + 4.29 * mary_hours + 9.82 * dale_hours + 4.24 * bobby_hours + 1.76 * paul_hours, gp.GRB.MINIMIZE)

# Add constraints - Likelihood to quit index
model.addConstr(11 * peggy_hours + 7 * paul_hours >= 73)
model.addConstr(6 * bobby_hours + 7 * paul_hours >= 138)
# ... (add all other likelihood to quit index constraints similarly)

# Add constraints - Dollar cost per hour
# ... (add all dollar cost per hour constraints similarly)


# Add constraints - Organization score
# ... (add all organization score constraints similarly)

# Add other constraints
model.addConstr(-2 * jean_hours + 6 * paul_hours >= 0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print("Laura hours:", laura_hours.x)
    print("Peggy hours:", peggy_hours.x)
    print("Jean hours:", jean_hours.x)
    print("Mary hours:", mary_hours.x)
    print("Dale hours:", dale_hours.x)
    print("Bobby hours:", bobby_hours.x)
    print("Paul hours:", paul_hours.x)

elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", model.status)

