
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(lb=0, name="hours worked by Laura", vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours worked by Peggy")
x3 = m.addVar(lb=0, name="hours worked by Jean", vtype=gp.GRB.CONTINUOUS)
x4 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours worked by Mary")
x5 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours worked by Dale")
x6 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours worked by Bobby")
x7 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours worked by Paul")

# Define the objective function
m.setObjective(8.46*x1 + 9.2*x2 + 3.03*x3 + 4.29*x4 + 9.82*x5 + 4.24*x6 + 1.76*x7, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 <= 991)
m.addConstr(11*x2 <= 991)
m.addConstr(14*x3 <= 991)
m.addConstr(5*x4 <= 991)
m.addConstr(25*x5 <= 890)
m.addConstr(6*x6 <= 785)
m.addConstr(7*x7 <= 785)
m.addConstr(4*x2 + 11*x7 >= 73)
m.addConstr(6*x6 + 7*x7 >= 138)
m.addConstr(11*x2 + 6*x6 >= 132)
m.addConstr(11*x2 + 14*x3 >= 73)
m.addConstr(5*x4 + 18*x7 >= 113)
m.addConstr(14*x3 + 18*x7 >= 52)
m.addConstr(11*x2 + 25*x5 >= 134)
m.addConstr(4*x1 + 14*x3 >= 80)
m.addConstr(14*x3 + 5*x4 >= 136)
m.addConstr(4*x1 + 6*x6 >= 102)
m.addConstr(11*x2 + 5*x4 >= 50)
m.addConstr(4*x1 + 7*x7 >= 106)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("hours worked by Laura: ", x1.varValue)
    print("hours worked by Peggy: ", x2.varValue)
    print("hours worked by Jean: ", x3.varValue)
    print("hours worked by Mary: ", x4.varValue)
    print("hours worked by Dale: ", x5.varValue)
    print("hours worked by Bobby: ", x6.varValue)
    print("hours worked by Paul: ", x7.varValue)
else:
    print("No solution found")
