
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
eggs = m.addVar(lb=0, name="eggs")
sashimi = m.addVar(lb=0, name="sashimi")
chicken_drumsticks = m.addVar(lb=0, name="chicken_drumsticks")
strips_of_bacon = m.addVar(lb=0, name="strips_of_bacon")
chicken_breasts = m.addVar(lb=0, name="chicken_breasts")


# Set objective function
m.setObjective(8.49 * eggs + 3.55 * sashimi + 1.54 * chicken_drumsticks + 9.73 * strips_of_bacon + 2.84 * chicken_breasts, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * eggs + 16 * sashimi + 2 * chicken_drumsticks + 6 * strips_of_bacon + 20 * chicken_breasts <= 553, "dollar_cost")
m.addConstr(1 * eggs + 1 * sashimi + 17 * chicken_drumsticks + 6 * strips_of_bacon + 8 * chicken_breasts <= 246, "calcium")
m.addConstr(16 * sashimi + 6 * strips_of_bacon + 20 * chicken_breasts >= 71, "cost_sashimi_bacon_breasts")
m.addConstr(6 * strips_of_bacon + 8 * chicken_breasts >= 25, "calcium_bacon_breasts")
m.addConstr(17 * chicken_drumsticks + 6 * strips_of_bacon >= 17, "calcium_drumsticks_bacon")
m.addConstr(4 * eggs - 7 * chicken_drumsticks + 8 * strips_of_bacon >= 0, "eggs_drumsticks_bacon_relation")
m.addConstr(6 * strips_of_bacon + 20 * chicken_breasts <= 311, "cost_bacon_breasts")
m.addConstr(5 * eggs + 16 * sashimi + 6 * strips_of_bacon <= 393, "cost_eggs_sashimi_bacon")
m.addConstr(5 * eggs + 16 * sashimi + 20 * chicken_breasts <= 208, "cost_eggs_sashimi_breasts")
m.addConstr(16 * sashimi + 2 * chicken_drumsticks + 20 * chicken_breasts <= 550, "cost_sashimi_drumsticks_breasts")
m.addConstr(16 * sashimi + 2 * chicken_drumsticks + 6 * strips_of_bacon <= 301, "cost_sashimi_drumsticks_bacon")
m.addConstr(5 * eggs + 16 * sashimi + 2 * chicken_drumsticks + 6 * strips_of_bacon + 20 * chicken_breasts <= 301, "total_cost")
m.addConstr(1 * eggs + 17 * chicken_drumsticks <= 95, "calcium_eggs_drumsticks")
m.addConstr(1 * eggs + 8 * chicken_breasts <= 186, "calcium_eggs_breasts")
m.addConstr(1 * sashimi + 8 * chicken_breasts <= 81, "calcium_sashimi_breasts")
m.addConstr(1 * sashimi + 17 * chicken_drumsticks <= 199, "calcium_sashimi_drumsticks")
m.addConstr(1 * eggs + 1 * sashimi <= 214, "calcium_eggs_sashimi")
m.addConstr(6 * strips_of_bacon + 8 * chicken_breasts <= 200, "calcium_bacon_breasts_max")
m.addConstr(1 * sashimi + 6 * strips_of_bacon <= 73, "calcium_sashimi_bacon")
m.addConstr(1 * eggs + 1 * sashimi + 8 * chicken_breasts <= 129, "calcium_eggs_sashimi_breasts")
m.addConstr(1 * eggs + 6 * strips_of_bacon + 8 * chicken_breasts <= 217, "calcium_eggs_bacon_breasts")
m.addConstr(1 * sashimi + 6 * strips_of_bacon + 8 * chicken_breasts <= 68, "calcium_sashimi_bacon_breasts")
m.addConstr(1 * eggs + 1 * sashimi + 17 * chicken_drumsticks <= 243, "calcium_eggs_sashimi_drumsticks")
m.addConstr(1 * eggs + 1 * sashimi + 17 * chicken_drumsticks + 6 * strips_of_bacon + 8 * chicken_breasts <= 243, "total_calcium")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

