
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x = m.addVars(6, lb=0, name=["x0", "x1", "x2", "x3", "x4", "x5"])


# Set objective
m.setObjective(3.1*x[0] + 2.11*x[1] + 3.22*x[2] + 4.4*x[3] + 8.47*x[4] + 2.42*x[5], gp.GRB.MAXIMIZE)

# Resource constraints
resource_constraints = {
    'r0': {'upper_bound': 783, 'coefficients': [5, 13, 16, 24, 17, 28]},
    'r1': {'upper_bound': 500, 'coefficients': [16, 20, 20, 15, 12, 10]},
    'r2': {'upper_bound': 707, 'coefficients': [22, 13, 15, 9, 9, 25]},
    'r3': {'upper_bound': 496, 'coefficients': [17, 7, 4, 17, 4, 21]}
}

for r, data in resource_constraints.items():
    m.addConstr(gp.quicksum(data['coefficients'][i] * x[i] for i in range(6)) <= data['upper_bound'], name=r)


# Additional constraints (simplified and deduplicated)
m.addConstr(13*x[1] + 24*x[3] >= 96)
m.addConstr(16*x[2] + 24*x[3] + 28*x[5] >= 114)
m.addConstr(5*x[0] + 13*x[1] + 16*x[2] >= 114)
m.addConstr(5*x[0] + 16*x[2] + 24*x[3] >= 114)
m.addConstr(5*x[0] + 16*x[2] + 28*x[5] >= 114)
m.addConstr(5*x[0] + 17*x[4] + 28*x[5] >= 114)

# ... (rest of the simplified constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

