
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hot_dogs", vtype=gp.GRB.INTEGER)  # hot dogs
x2 = m.addVar(name="cantaloupes")  # cantaloupes
x3 = m.addVar(name="cornichons", vtype=gp.GRB.INTEGER)  # cornichons
x4 = m.addVar(name="fruit_salads", vtype=gp.GRB.INTEGER)  # fruit salads
x5 = m.addVar(name="ravioli")  # ravioli

# Objective function
m.setObjective(6.2*x1**2 + 7.63*x1*x2 + 9.51*x1*x5 + 2.02*x2**2 + 2.71*x2*x3 + 5.94*x2*x4 + 7.99*x2*x5 + 
               9.86*x3**2 + 2.98*x3*x4 + 4.51*x4**2 + 1.45*x1 + 2.82*x2 + 1.43*x3 + 6.2*x4 + 7.91*x5, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(1.64*x1 + 1.95*x2 + 1.38*x3 + 1.98*x4 + 1.97*x5 <= 293, "total_fat")
m.addConstr(1.38*x3 + 1.97*x5 >= 32, "fat_from_cornichons_ravioli")
m.addConstr(1.64*x1 + 1.98*x4 >= 40, "fat_from_hot_dogs_fruit_salads")
m.addConstr(1.98*x4 + 1.97*x5 >= 27, "fat_from_fruit_salads_ravioli")
m.addConstr(1.64*x1 + 1.38*x3 >= 46, "fat_from_hot_dogs_cornichons")
m.addConstr(1.64*x1 + 1.38*x3 + 1.97*x5 >= 49, "fat_from_hot_dogs_cornichons_ravioli")
m.addConstr(1.95*x2 + 1.98*x4 + 1.97*x5 >= 49, "fat_from_cantaloupes_fruit_salads_ravioli")
m.addConstr(1.95**2*x2**2 + 1.38**2*x3**2 + 1.98**2*x4**2 >= 49, "fat_from_squares")
m.addConstr(1.64**2*x1**2 + 1.38**2*x3**2 + 1.98**2*x4**2 >= 49, "fat_from_hot_dogs_cornichons_fruit_salads_squares")
m.addConstr(1.64*x1 + 1.95*x2 + 1.97*x5 >= 49, "fat_from_hot_dogs_cantaloupes_ravioli")
m.addConstr(1.64*x1 + 1.95*x2 + 1.98*x4 >= 49, "fat_from_hot_dogs_cantaloupes_fruit_salads")
m.addConstr(1.64*x1 + 1.98*x4 + 1.97*x5 >= 49, "fat_from_hot_dogs_fruit_salads_ravioli")
m.addConstr(1.64**2*x1**2 + 1.38**2*x3**2 + 1.97**2*x5**2 >= 36, "fat_from_hot_dogs_cornichons_ravioli_squares")
m.addConstr(1.95*x2 + 1.98*x4 + 1.97*x5 >= 36, "fat_from_cantaloupes_fruit_salads_ravioli")
m.addConstr(1.95**2*x2**2 + 1.38**2*x3**2 + 1.98**2*x4**2 >= 36, "fat_from_cantaloupes_cornichons_fruit_salads_squares")
m.addConstr(1.64*x1 + 1.38*x3 + 1.98*x4 >= 36, "fat_from_hot_dogs_cornichons_fruit_salads")
m.addConstr(10*x3 - 2*x5 >= 0, "cornichons_ravioli_constraint")
m.addConstr(-4*x1 - 8*x2 + 3*x4 >= 0, "hot_dogs_cantaloupes_fruit_salads_constraint")
m.addConstr(1.95**2*x2**2 + 1.98**2*x4**2 <= 216, "cantaloupes_fruit_salads_squares_constraint")
m.addConstr(1.95*x2 + 1.97*x5 <= 76, "cantaloupes_ravioli_constraint")
m.addConstr(1.64*x1 + 1.98*x4 <= 84, "hot_dogs_fruit_salads_constraint")
m.addConstr(1.64*x1 + 1.38*x3 <= 107, "hot_dogs_cornichons_constraint")
m.addConstr(1.38**2*x3**2 + 1.97**2*x5**2 <= 193, "cornichons_ravioli_squares_constraint")
m.addConstr(1.38*x3 + 1.98*x4 <= 217, "cornichons_fruit_salads_constraint")
m.addConstr(1.64*x1 + 1.97*x5 <= 102, "hot_dogs_ravioli_constraint")
m.addConstr(1.64*x1 + 1.95*x2 <= 165, "hot_dogs_cantaloupes_constraint")
m.addConstr(1.64*x1 + 1.95*x2 + 1.97*x5 <= 191, "hot_dogs_cantaloupes_ravioli_constraint")
m.addConstr(1.64*x1 + 1.95*x2 + 1.38*x3 + 1.98*x4 + 1.97*x5 <= 191, "total_fat_from_all")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hot dogs: ", x1.varValue)
    print("Cantaloupes: ", x2.varValue)
    print("Cornichons: ", x3.varValue)
    print("Fruit salads: ", x4.varValue)
    print("Ravioli: ", x5.varValue)
else:
    print("The model is infeasible")
