
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("power_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="network_administrators")


    # Set objective function
    m.setObjective(3*x0 + 4*x1 + 3*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(15*x0 + 1*x1 + 19*x2 <= 234, "power_consumption_limit")
    m.addConstr(1*x1 + 19*x2 >= 41, "security_admin_power_minimum")
    m.addConstr(15*x0 + 1*x1 >= 53, "alerts_engineers_power_minimum")
    m.addConstr(15*x0 + 1*x1 + 19*x2 >= 40, "total_power_minimum") 
    m.addConstr(-2*x1 + 10*x2 >= 0, "engineers_administrators_ratio")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('automatic_alerts:', x0.x)
        print('security_engineers:', x1.x)
        print('network_administrators:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
