
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")
x2 = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
x3 = m.addVar(vtype=GRB.INTEGER, name="network_administrators")

# Set objective function
m.setObjective(3*x1 + 4*x2 + 3*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(15*x1 + x2 + 19*x3 >= 40, "total_power_consumption")
m.addConstr(x2 + 19*x3 >= 41, "security_and_network_power")
m.addConstr(15*x1 + x2 >= 53, "alerts_and_security_power")
m.addConstr(-2*x2 + 10*x3 >= 0, "security_vs_network")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Automatic Alerts: {x1.x}")
    print(f"Security Engineers: {x2.x}")
    print(f"Network Administrators: {x3.x}")
else:
    print("No optimal solution found")
