
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="automatic_alerts", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="security_engineers", vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name="network_administrators", vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(3*x1 + 4*x2 + 3*x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(15*x1 + x2 + 19*x3 <= 234, name="power_consumption_upper_bound")
model.addConstr(x2 + 19*x3 >= 41, name="security_engineers_network_administrators_power")
model.addConstr(15*x1 + x2 >= 53, name="automatic_alerts_security_engineers_power")
model.addConstr(-2*x2 + 10*x3 >= 0, name="security_engineers_network_administrators_relationship")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Automatic Alerts: ", x1.varValue)
    print("Security Engineers: ", x2.varValue)
    print("Network Administrators: ", x3.varValue)
else:
    print("The model is infeasible")
