
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # hours worked by Jean
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # hours worked by Mary


    # Set objective function
    model.setObjective(8.91 * x0 * x1 + 3.63 * x0 + 2.92 * x1, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(14 * x0 + 14 * x1 >= 39, "c0")
    model.addConstr(11 * x0 + 7 * x1 >= 61, "c1")
    model.addConstr(10 * x0 * x0 - 2 * x1 * x1 >= 0, "c2")
    model.addConstr(14*14 * x0 * x0 + 14*14 * x1 * x1 <= 87, "c3")
    model.addConstr(11 * x0 + 7 * x1 <= 77, "c4")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
