
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Jean", lb=0)  # hours worked by Jean
x2 = m.addVar(name="hours_worked_by_Mary", lb=0)  # hours worked by Mary

# Define the objective function
m.setObjective(8.91 * x1 * x2 + 3.63 * x1 + 2.92 * x2, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(14 * x1 + 14 * x2 >= 39, name="dollar_cost_constraint")
m.addConstr(11 * x1 + 7 * x2 >= 61, name="likelihood_to_quit_constraint")
m.addConstr(10 * x1**2 - 2 * x2**2 >= 0, name="quadratic_constraint")
m.addConstr(x1**2 + x2**2 <= 87, name="dollar_cost_squared_constraint")
m.addConstr(11 * x1 + 7 * x2 <= 77, name="likelihood_to_quit_upper_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Jean: {x1.varValue}")
    print(f"Hours worked by Mary: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
