
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("minimize_work_hours")

    # Create variables
    laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
    hank_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")
    mary_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")


    # Set objective function
    m.setObjective(2.81 * laura_hours + 5.39 * hank_hours + 8.18 * mary_hours, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(23.08 * laura_hours + 9.62 * hank_hours >= 20, "c1")
    m.addConstr(23.08 * laura_hours + 9.62 * hank_hours + 8.92 * mary_hours >= 20, "c2")
    m.addConstr(20.84 * laura_hours + 17.17 * hank_hours >= 23, "c3")
    m.addConstr(20.84 * laura_hours + 20.23 * mary_hours >= 44, "c4")
    m.addConstr(20.84 * laura_hours + 17.17 * hank_hours + 20.23 * mary_hours >= 44, "c5")
    m.addConstr(-10 * hank_hours + 5 * mary_hours >= 0, "c6")
    m.addConstr(-8 * laura_hours + 1 * hank_hours >= 0, "c7")
    m.addConstr(20.84 * laura_hours + 17.17 * hank_hours + 20.23 * mary_hours <= 150, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Laura Hours: %g' % laura_hours.x)
        print('Hank Hours: %g' % hank_hours.x)
        print('Mary Hours: %g' % mary_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
