
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Laura", lb=0)
    x2 = model.addVar(name="hours_worked_by_Hank", lb=0)
    x3 = model.addVar(name="hours_worked_by_Mary", lb=0)

    # Objective function
    model.setObjective(2.81*x1 + 5.39*x2 + 8.18*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(23.08*x1 >= 23.08)
    model.addConstr(20.84*x1 >= 20.84)
    model.addConstr(9.62*x2 >= 9.62)
    model.addConstr(17.17*x2 >= 17.17)
    model.addConstr(8.92*x3 >= 8.92)
    model.addConstr(20.23*x3 >= 20.23)
    model.addConstr(23.08*x1 + 9.62*x2 >= 20)
    model.addConstr(23.08*x1 + 9.62*x2 + 8.92*x3 >= 20)
    model.addConstr(20.84*x1 + 17.17*x2 >= 23)
    model.addConstr(20.84*x1 + 20.23*x3 >= 44)
    model.addConstr(20.84*x1 + 17.17*x2 + 20.23*x3 >= 44)
    model.addConstr(-10*x2 + 5*x3 >= 0)
    model.addConstr(-8*x1 + x2 >= 0)
    model.addConstr(20.84*x1 + 17.17*x2 + 20.23*x3 <= 150)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Laura: ", x1.varValue)
        print("Hours worked by Hank: ", x2.varValue)
        print("Hours worked by Mary: ", x3.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
