
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Cost")

    # Create variables
    peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
    laura = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="laura")
    george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
    mary = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="mary")


    # Set objective function
    model.setObjective(7.35 * peggy + 3.76 * laura + 4.62 * george + 9.64 * mary, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(22 * peggy + 4 * george >= 49, "c1")
    model.addConstr(22 * peggy + 16 * mary >= 66, "c2")
    model.addConstr(10 * laura + 16 * mary >= 72, "c3")
    model.addConstr(10 * laura + 4 * george + 16 * mary >= 71, "c4")
    model.addConstr(22 * peggy + 10 * laura + 16 * mary >= 71, "c5")
    model.addConstr(10 * laura + 4 * george + 16 * mary >= 69, "c6")
    model.addConstr(22 * peggy + 10 * laura + 16 * mary >= 69, "c7")
    model.addConstr(22 * peggy + 10 * laura + 4 * george + 16 * mary >= 69, "c8")
    model.addConstr(10 * peggy - 3 * mary >= 0, "c9")
    model.addConstr(5 * george - 5 * mary >= 0, "c10")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Peggy:', peggy.x)
        print('Laura:', laura.x)
        print('George:', george.x)
        print('Mary:', mary.x)

    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
        model.computeIIS()
        model.write("model.ilp")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
