
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Peggy", lb=0)  # No upper bound given
x2 = m.addVar(name="hours_worked_by_Laura", lb=0)  # No upper bound given
x3 = m.addVar(name="hours_worked_by_George", lb=0)  # No upper bound given
x4 = m.addVar(name="hours_worked_by_Mary", lb=0, vtype=gp.GRB.INTEGER)  # Must be integer

# Define the objective function
m.setObjective(7.35*x1 + 3.76*x2 + 4.62*x3 + 9.64*x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(22*x1 + 4*x3 >= 49)
m.addConstr(22*x1 + 16*x4 >= 66)
m.addConstr(10*x2 + 16*x4 >= 72)
m.addConstr(10*x2 + 4*x3 + 16*x4 >= 71)
m.addConstr(22*x1 + 10*x2 + 16*x4 >= 71)
m.addConstr(10*x2 + 4*x3 + 16*x4 >= 69)
m.addConstr(22*x1 + 10*x2 + 16*x4 >= 69)
m.addConstr(22*x1 + 10*x2 + 4*x3 + 16*x4 >= 69)
m.addConstr(10*x1 - 3*x4 >= 0)
m.addConstr(5*x3 - 5*x4 >= 0)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Peggy: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
    print("Hours worked by George: ", x3.varValue)
    print("Hours worked by Mary: ", x4.varValue)
else:
    print("The model is infeasible")
