
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin B1
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of iron
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2") # grams of protein
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3") # milligrams of vitamin A


    # Set objective function
    m.setObjective(1*x0 + 9*x1 + 9*x2 + 2*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1*x1 + 5*x2 >= 33, "c1")
    m.addConstr(5*x2 + 3*x3 <= 108, "c2")
    m.addConstr(1*x0 + 5*x2 <= 181, "c3")
    m.addConstr(1*x0 + 9*x1 + 5*x2 <= 158, "c4")
    m.addConstr(1*x0 + 5*x2 + 3*x3 <= 177, "c5")
    m.addConstr(9*x1 + 5*x2 + 3*x3 <= 123, "c6")
    m.addConstr(1*x0 + 9*x1 + 3*x3 <= 141, "c7")
    m.addConstr(1*x0 + 9*x1 + 5*x2 + 3*x3 <= 141, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
