
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B1
x2 = m.addVar(name="x2")  # milligrams of iron
x3 = m.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # grams of protein
x4 = m.addVar(name="x4", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin A

# Objective function
m.setObjective(1*x1 + 9*x2 + 9*x3 + 2*x4, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(1*x1 <= 184)
m.addConstr(9*x2 <= 184)
m.addConstr(5*x3 <= 184)
m.addConstr(3*x4 <= 184)
m.addConstr(9*x2 + 5*x3 >= 33)
m.addConstr(5*x3 + 3*x4 <= 108)
m.addConstr(1*x1 + 5*x3 <= 181)
m.addConstr(1*x1 + 9*x2 + 5*x3 <= 158)
m.addConstr(1*x1 + 5*x3 + 3*x4 <= 177)
m.addConstr(9*x2 + 5*x3 + 3*x4 <= 123)
m.addConstr(1*x1 + 9*x2 + 3*x4 <= 141)
m.addConstr(1*x1 + 9*x2 + 5*x3 + 3*x4 <= 141)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B1: {x1.varValue}")
    print(f"Milligrams of iron: {x2.varValue}")
    print(f"Grams of protein: {x3.varValue}")
    print(f"Milligrams of vitamin A: {x4.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
