
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours worked by Mary")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours worked by Peggy")


    # Set objective function
    model.setObjective(6.86 * x0 + 6.82 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(14 * x0 + 3 * x1 >= 27, "c0")
    model.addConstr(5 * x0 + 12 * x1 >= 25, "c1")
    model.addConstr(4 * x0 + 9 * x1 >= 23, "c2")
    model.addConstr(7 * x0 + 9 * x1 >= 18, "c3")
    model.addConstr(12 * x0 + 13 * x1 >= 36, "c4")
    model.addConstr(1 * x0 - 10 * x1 >= 0, "c5")
    model.addConstr(14 * x0 + 3 * x1 <= 68, "c6")
    model.addConstr(5 * x0 + 12 * x1 <= 103, "c7")
    model.addConstr(4 * x0 + 9 * x1 <= 54, "c8")
    model.addConstr(7 * x0 + 9 * x1 <= 49, "c9")
    model.addConstr(12 * x0 + 13 * x1 <= 53, "c10")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
