
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Mary', lb=0)  # No upper bound for hours worked
    x2 = model.addVar(name='hours_worked_by_Peggy', lb=0)  # No upper bound for hours worked

    # Define the objective function
    model.setObjective(6.86 * x1 + 6.82 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(14 * x1 + 3 * x2 >= 27)
    model.addConstr(5 * x1 + 12 * x2 >= 25)
    model.addConstr(4 * x1 + 9 * x2 >= 23)
    model.addConstr(7 * x1 + 9 * x2 >= 18)
    model.addConstr(12 * x1 + 13 * x2 >= 36)
    model.addConstr(x1 - 10 * x2 >= 0)
    model.addConstr(14 * x1 + 3 * x2 <= 68)
    model.addConstr(5 * x1 + 12 * x2 <= 103)
    model.addConstr(4 * x1 + 9 * x2 <= 54)
    model.addConstr(7 * x1 + 9 * x2 <= 49)
    model.addConstr(12 * x1 + 13 * x2 <= 53)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Mary: {x1.varValue}')
        print(f'Hours worked by Peggy: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
