
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cantaloupes = m.addVar(lb=0, name="cantaloupes")
lemons = m.addVar(lb=0, name="lemons")
ham_sandwiches = m.addVar(lb=0, name="ham_sandwiches")
strawberries = m.addVar(lb=0, name="strawberries")


# Set objective function
m.setObjective(7.05 * cantaloupes + 1.79 * lemons + 9.61 * ham_sandwiches + 3.42 * strawberries, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(29 * cantaloupes + 19 * strawberries >= 62)
m.addConstr(1 * lemons + 23 * ham_sandwiches >= 62)
m.addConstr(23 * ham_sandwiches + 19 * strawberries >= 80)
m.addConstr(1 * lemons + 23 * ham_sandwiches + 19 * strawberries >= 104)
m.addConstr(29 * cantaloupes + 1 * lemons + 23 * ham_sandwiches >= 104)
m.addConstr(29 * cantaloupes + 1 * lemons + 19 * strawberries >= 104)
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 104)
m.addConstr(1 * lemons + 23 * ham_sandwiches + 19 * strawberries >= 95)
m.addConstr(29 * cantaloupes + 1 * lemons + 23 * ham_sandwiches >= 95)
m.addConstr(29 * cantaloupes + 1 * lemons + 19 * strawberries >= 95)
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 95)
m.addConstr(1 * lemons + 23 * ham_sandwiches + 19 * strawberries >= 57)
m.addConstr(29 * cantaloupes + 1 * lemons + 23 * ham_sandwiches >= 57)
m.addConstr(29 * cantaloupes + 1 * lemons + 19 * strawberries >= 57)
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 57)
m.addConstr(1 * lemons + 23 * ham_sandwiches + 19 * strawberries >= 108)
m.addConstr(29 * cantaloupes + 1 * lemons + 23 * ham_sandwiches >= 108)
m.addConstr(29 * cantaloupes + 1 * lemons + 19 * strawberries >= 108)
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 108)
m.addConstr(29 * cantaloupes + 1 * lemons + 23 * ham_sandwiches + 19 * strawberries >= 108)
m.addConstr(7 * cantaloupes + 6 * ham_sandwiches >= 45)
m.addConstr(7 * lemons + 6 * ham_sandwiches >= 24)
m.addConstr(7 * cantaloupes + 26 * strawberries >= 30)
m.addConstr(7 * cantaloupes + 7 * lemons + 26 * strawberries >= 40)
m.addConstr(7 * cantaloupes + 6 * ham_sandwiches + 26 * strawberries >= 40)
m.addConstr(7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 40)
m.addConstr(7 * cantaloupes + 7 * lemons + 26 * strawberries >= 41)
m.addConstr(7 * cantaloupes + 6 * ham_sandwiches + 26 * strawberries >= 41)
m.addConstr(7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 41)
m.addConstr(7 * cantaloupes + 7 * lemons + 26 * strawberries >= 31)
m.addConstr(7 * cantaloupes + 6 * ham_sandwiches + 26 * strawberries >= 31)
m.addConstr(7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 31)
m.addConstr(7 * cantaloupes + 7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 31)
m.addConstr(9 * cantaloupes - 2 * strawberries >= 0)
m.addConstr(-3 * ham_sandwiches + 9 * strawberries >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Problem is infeasible.')
