
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="cantaloupes", lb=0)
x1 = m.addVar(name="lemons", lb=0)
x2 = m.addVar(name="ham sandwiches", lb=0)
x3 = m.addVar(name="strawberries", lb=0)

# Objective function
m.setObjective(7.05 * x0 + 1.79 * x1 + 9.61 * x2 + 3.42 * x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(29 * x0 <= 435)
m.addConstr(7 * x0 <= 247)
m.addConstr(1 * x1 <= 435)
m.addConstr(7 * x1 <= 247)
m.addConstr(23 * x2 <= 435)
m.addConstr(6 * x2 <= 247)
m.addConstr(19 * x3 <= 435)
m.addConstr(26 * x3 <= 247)

m.addConstr(29 * x0 + 19 * x3 >= 62)
m.addConstr(1 * x1 + 23 * x2 >= 62)
m.addConstr(23 * x2 + 19 * x3 >= 80)
m.addConstr(1 * x1 + 23 * x2 + 19 * x3 >= 104)
m.addConstr(29 * x0 + 1 * x1 + 23 * x2 >= 104)
m.addConstr(29 * x0 + 1 * x1 + 19 * x3 >= 104)
m.addConstr(29 * x0 + 23 * x2 + 19 * x3 >= 104)
m.addConstr(1 * x1 + 23 * x2 + 19 * x3 >= 95)
m.addConstr(29 * x0 + 1 * x1 + 23 * x2 >= 95)
m.addConstr(29 * x0 + 1 * x1 + 19 * x3 >= 95)
m.addConstr(29 * x0 + 23 * x2 + 19 * x3 >= 95)
m.addConstr(1 * x1 + 23 * x2 + 19 * x3 >= 57)
m.addConstr(29 * x0 + 1 * x1 + 23 * x2 >= 57)
m.addConstr(29 * x0 + 1 * x1 + 19 * x3 >= 57)
m.addConstr(29 * x0 + 23 * x2 + 19 * x3 >= 57)
m.addConstr(1 * x1 + 23 * x2 + 19 * x3 >= 108)
m.addConstr(29 * x0 + 1 * x1 + 23 * x2 >= 108)
m.addConstr(29 * x0 + 1 * x1 + 19 * x3 >= 108)
m.addConstr(29 * x0 + 23 * x2 + 19 * x3 >= 108)
m.addConstr(29 * x0 + 1 * x1 + 23 * x2 + 19 * x3 >= 108)

m.addConstr(7 * x0 + 6 * x2 >= 45)
m.addConstr(7 * x1 + 6 * x2 >= 24)
m.addConstr(7 * x0 + 26 * x3 >= 30)
m.addConstr(7 * x0 + 7 * x1 + 26 * x3 >= 40)
m.addConstr(7 * x0 + 6 * x2 + 26 * x3 >= 40)
m.addConstr(7 * x1 + 6 * x2 + 26 * x3 >= 40)
m.addConstr(7 * x0 + 7 * x1 + 26 * x3 >= 41)
m.addConstr(7 * x0 + 6 * x2 + 26 * x3 >= 41)
m.addConstr(7 * x1 + 6 * x2 + 26 * x3 >= 41)
m.addConstr(7 * x0 + 7 * x1 + 26 * x3 >= 31)
m.addConstr(7 * x0 + 6 * x2 + 26 * x3 >= 31)
m.addConstr(7 * x1 + 6 * x2 + 26 * x3 >= 31)
m.addConstr(7 * x0 + 7 * x1 + 6 * x2 + 26 * x3 >= 31)

m.addConstr(9 * x0 - 2 * x3 >= 0)
m.addConstr(-3 * x2 + 9 * x3 >= 0)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("cantaloupes: ", x0.varValue)
    print("lemons: ", x1.varValue)
    print("ham sandwiches: ", x2.varValue)
    print("strawberries: ", x3.varValue)
else:
    print("The model is infeasible")
