
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_cobs")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")


    # Set objective function
    m.setObjective(6*x0 + 4*x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1*x0 + 13*x1 >= 25, "fiber_min")
    m.addConstr(13*x0 + 12*x1 >= 32, "calcium_min")
    m.addConstr(-5*x0 + 4*x1 >= 0, "cob_pie_ratio")
    m.addConstr(1*x0 + 13*x1 <= 92, "fiber_max")
    m.addConstr(13*x0 + 12*x1 <= 41, "calcium_max")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        print("Corn cobs:", x0.x)
        print("Apple pies:", x1.x)


except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model optimized correctly.")

