
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="corn_cobs")  # Corn cobs can be any non-negative value (float)
x1 = m.addVar(lb=0, name="apple_pies")  # Apple pies can also be any non-negative float

# Objective function: Maximize
m.setObjective(6*x0 + 4*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(x0 + 13*x1 >= 25, "Minimum_Fiber")
m.addConstr(13*x0 + 12*x1 >= 32, "Minimum_Calcium")
m.addConstr(-5*x0 + 4*x1 >= 0, "Additional_Constraint")
m.addConstr(x0 + 13*x1 <= 92, "Maximum_Fiber")
m.addConstr(13*x0 + 12*x1 <= 41, "Maximum_Calcium")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Corn cobs: {x0.x}, Apple pies: {x1.x}")
else:
    print("No optimal solution found.")
