
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='corn_cobs', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = model.addVar(name='apple_pies', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Define the objective function
model.setObjective(6 * x1 + 4 * x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(x1 + 13 * x2 <= 92, name='fiber_constraint')
model.addConstr(13 * x1 + 12 * x2 <= 41, name='calcium_constraint')
model.addConstr(x1 + 13 * x2 >= 25, name='min_fiber_constraint')
model.addConstr(13 * x1 + 12 * x2 >= 32, name='min_calcium_constraint')
model.addConstr(-5 * x1 + 4 * x2 >= 0, name='balance_constraint')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Corn cobs: ', x1.x)
    print('Apple pies: ', x2.x)
else:
    print('The model is infeasible')
