
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    calcium = m.addVar(vtype=GRB.CONTINUOUS, name="calcium")
    zinc = m.addVar(vtype=GRB.CONTINUOUS, name="zinc")
    vitamin_b1 = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b1")
    vitamin_b5 = m.addVar(vtype=GRB.INTEGER, name="vitamin_b5")


    # Set objective function
    obj = 5.08*calcium*zinc + 6.35*zinc**2 + 6.26*zinc*vitamin_b1 + 6.59*zinc*vitamin_b5 + 3.56*vitamin_b1**2
    m.setObjective(obj, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3.53*calcium + 10.75*zinc + 6.16*vitamin_b1 + 0.26*vitamin_b5 <= 376, "c0")
    m.addConstr(15.02*calcium + 13.63*zinc + 8.91*vitamin_b1 + 3.1*vitamin_b5 <= 184, "c1")
    m.addConstr(6.16*vitamin_b1 + 0.26*vitamin_b5 >= 81, "c2")
    m.addConstr(3.53*calcium**2 + 10.75*zinc**2 >= 58, "c3")
    m.addConstr(15.02*calcium + 13.63*zinc + 3.1*vitamin_b5 >= 40, "c4")
    m.addConstr(15.02*calcium + 13.63*zinc + 8.91*vitamin_b1 >= 40, "c5")
    m.addConstr(13.63*zinc + 8.91*vitamin_b1 + 3.1*vitamin_b5 >= 40, "c6")
    m.addConstr(15.02*calcium**2 + 13.63*zinc**2 + 3.1*vitamin_b5**2 >= 24, "c7")
    m.addConstr(15.02*calcium + 13.63*zinc + 8.91*vitamin_b1 >= 24, "c8")
    m.addConstr(13.63*zinc**2 + 8.91*vitamin_b1**2 + 3.1*vitamin_b5**2 >= 24, "c9")
    m.addConstr(15.02*calcium + 13.63*zinc + 3.1*vitamin_b5 >= 33, "c10")
    m.addConstr(15.02*calcium + 13.63*zinc + 8.91*vitamin_b1 >= 33, "c11")
    m.addConstr(13.63*zinc + 8.91*vitamin_b1 + 3.1*vitamin_b5 >= 33, "c12")
    m.addConstr(3.53*calcium**2 + 10.75*zinc**2 <= 186, "c13")
    m.addConstr(10.75*zinc + 0.26*vitamin_b5 <= 136, "c14")
    m.addConstr(3.53*calcium + 6.16*vitamin_b1 <= 190, "c15")
    m.addConstr(3.53*calcium**2 + 6.16*vitamin_b1**2 + 0.26*vitamin_b5**2 <= 370, "c16")
    m.addConstr(15.02*calcium**2 + 3.1*vitamin_b5**2 <= 159, "c17")
    m.addConstr(8.91*vitamin_b1 + 3.1*vitamin_b5 <= 142, "c18")
    m.addConstr(15.02*calcium**2 + 8.91*vitamin_b1**2 <= 50, "c19")
    m.addConstr(15.02*calcium**2 + 13.63*zinc**2 <= 147, "c20")
    m.addConstr(15.02*calcium**2 + 13.63*zinc**2 + 3.1*vitamin_b5**2 <= 120, "c21")
    m.addConstr(15.02*calcium**2 + 13.63*zinc**2 + 8.91*vitamin_b1**2 <= 102, "c22")
    m.addConstr(15.02*calcium**2 + 8.91*vitamin_b1**2 + 3.1*vitamin_b5**2 <= 78, "c23")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('calcium:', calcium.x)
        print('zinc:', zinc.x)
        print('vitamin_b1:', vitamin_b1.x)
        print('vitamin_b5:', vitamin_b5.x)

    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
