
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=-gp.GRB.INFINITY)  # milligrams of calcium
x1 = m.addVar(name="x1", lb=-gp.GRB.INFINITY)  # milligrams of zinc
x2 = m.addVar(name="x2", lb=-gp.GRB.INFINITY)  # milligrams of vitamin B1
x3 = m.addVar(name="x3", lb=0, type=gp.GRB.INTEGER)  # milligrams of vitamin B5

# Define the objective function
m.setObjective(5.08*x0*x1 + 6.35*x1**2 + 6.26*x1*x2 + 6.59*x1*x3 + 3.56*x2**2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.53*x0 <= 376)
m.addConstr(15.02*x0 <= 184)
m.addConstr(10.75*x1 <= 376)
m.addConstr(13.63*x1 <= 184)
m.addConstr(6.16*x2 <= 376)
m.addConstr(8.91*x2 <= 184)
m.addConstr(0.26*x3 <= 376)
m.addConstr(3.1*x3 <= 184)
m.addConstr(6.16*x2 + 0.26*x3 >= 81)
m.addConstr(3.53**2*x0**2 + 10.75**2*x1**2 >= 58)
m.addConstr(15.02*x0 + 13.63*x1 + 3.1*x3 >= 40)
m.addConstr(15.02*x0 + 13.63*x1 + 8.91*x2 >= 40)
m.addConstr(13.63*x1 + 8.91*x2 + 3.1*x3 >= 40)
m.addConstr(15.02**2*x0**2 + 13.63**2*x1**2 + 3.1**2*x3**2 >= 24)
m.addConstr(15.02*x0 + 13.63*x1 + 8.91*x2 >= 24)
m.addConstr(13.63**2*x1**2 + 8.91**2*x2**2 + 3.1**2*x3**2 >= 24)
m.addConstr(15.02*x0 + 13.63*x1 + 3.1*x3 >= 33)
m.addConstr(15.02*x0 + 13.63*x1 + 8.91*x2 >= 33)
m.addConstr(13.63*x1 + 8.91*x2 + 3.1*x3 >= 33)
m.addConstr(3.53**2*x0**2 + 10.75**2*x1**2 <= 186)
m.addConstr(10.75*x1 + 0.26*x3 <= 136)
m.addConstr(3.53*x0 + 6.16*x2 <= 190)
m.addConstr(3.53**2*x0**2 + 6.16**2*x2**2 + 0.26**2*x3**2 <= 370)
m.addConstr(3.53*x0 + 10.75*x1 + 6.16*x2 + 0.26*x3 <= 370)
m.addConstr(15.02**2*x0**2 + 3.1**2*x3**2 <= 159)
m.addConstr(8.91*x2 + 3.1*x3 <= 142)
m.addConstr(15.02**2*x0**2 + 8.91**2*x2**2 <= 50)
m.addConstr(3.53**2*x0**2 + 10.75**2*x1**2 <= 147)
m.addConstr(3.53**2*x0**2 + 10.75**2*x1**2 + 0.26**2*x3**2 <= 120)
m.addConstr(3.53**2*x0**2 + 10.75**2*x1**2 + 6.16**2*x2**2 <= 102)
m.addConstr(15.02**2*x0**2 + 8.91**2*x2**2 + 3.1**2*x3**2 <= 78)
m.addConstr(15.02*x0 + 13.63*x1 + 3.1*x3 <= 78)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
