
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
steaks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="steaks")
pizza = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pizza")
chicken = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken")
corn = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn")


# Set objective function
m.setObjective(9*steaks + 6*pizza + 1*chicken + 3*corn, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8.01*chicken + 6.38*corn >= 16, "iron_chicken_corn")
m.addConstr(2.73*steaks + 8.01*chicken >= 28, "iron_steaks_chicken")
m.addConstr(2.73*steaks + 6.21*pizza >= 14, "iron_steaks_pizza")
m.addConstr(6.21*pizza + 8.01*chicken >= 26, "iron_pizza_chicken")
m.addConstr(2.73*steaks + 6.38*corn >= 29, "iron_steaks_corn")
m.addConstr(2.73*steaks + 6.21*pizza + 8.01*chicken + 6.38*corn >= 29, "iron_total_min")
m.addConstr(2.53*steaks + 2.58*corn >= 32, "sourness_steaks_corn")
m.addConstr(0.64*chicken + 2.58*corn >= 21, "sourness_chicken_corn")
m.addConstr(2.53*steaks + 1.96*pizza >= 25, "sourness_steaks_pizza")
m.addConstr(1.96*pizza + 2.58*corn >= 23, "sourness_pizza_corn")
m.addConstr(1.96*pizza + 0.64*chicken >= 25, "sourness_pizza_chicken")
m.addConstr(2.53*steaks + 1.96*pizza + 0.64*chicken + 2.58*corn >= 25, "sourness_total")
m.addConstr(2*steaks - 7*corn >= 0, "steaks_corn_relation")
m.addConstr(2.73*steaks + 6.21*pizza <= 139, "iron_steaks_pizza_max")
m.addConstr(6.21*pizza + 6.38*corn <= 49, "iron_pizza_corn_max")
m.addConstr(2.53*steaks + 1.96*pizza <= 107, "sourness_steaks_pizza_max")
m.addConstr(0.64*chicken + 2.58*corn <= 91, "sourness_chicken_corn_max")

# Resource Constraints
m.addConstr(2.73*steaks + 6.21*pizza + 8.01*chicken + 6.38*corn <= 178, "iron_limit")
m.addConstr(2.53*steaks + 1.96*pizza + 0.64*chicken + 2.58*corn <= 220, "sourness_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

