
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='steaks', lb=0)
x1 = model.addVar(name='slices of pizza', lb=0)
x2 = model.addVar(name='chicken drumsticks', lb=0)
x3 = model.addVar(name='corn cobs', lb=0)

# Set the objective function
model.setObjective(9 * x0 + 6 * x1 + x2 + 3 * x3, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(2.73 * x0 + 6.21 * x1 + 8.01 * x2 + 6.38 * x3 <= 178)
model.addConstr(2.53 * x0 + 1.96 * x1 + 0.64 * x2 + 2.58 * x3 <= 220)
model.addConstr(8.01 * x2 + 6.38 * x3 >= 16)
model.addConstr(2.73 * x0 + 8.01 * x2 >= 28)
model.addConstr(2.73 * x0 + 6.21 * x1 >= 14)
model.addConstr(6.21 * x1 + 8.01 * x2 >= 26)
model.addConstr(2.73 * x0 + 6.38 * x3 >= 29)
model.addConstr(2.73 * x0 + 6.21 * x1 + 8.01 * x2 + 6.38 * x3 >= 29)
model.addConstr(2.53 * x0 + 2.58 * x3 >= 32)
model.addConstr(0.64 * x2 + 2.58 * x3 >= 21)
model.addConstr(2.53 * x0 + 1.96 * x1 >= 25)
model.addConstr(1.96 * x1 + 2.58 * x3 >= 23)
model.addConstr(1.96 * x1 + 0.64 * x2 >= 25)
model.addConstr(2.53 * x0 + 1.96 * x1 + 0.64 * x2 + 2.58 * x3 >= 25)
model.addConstr(2 * x0 - 7 * x3 >= 0)
model.addConstr(2.73 * x0 + 6.21 * x1 <= 139)
model.addConstr(6.21 * x1 + 6.38 * x3 <= 49)
model.addConstr(2.53 * x0 + 1.96 * x1 <= 107)
model.addConstr(0.64 * x2 + 2.58 * x3 <= 91)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objval)
    print('Steaks: ', x0.varValue)
    print('Slices of pizza: ', x1.varValue)
    print('Chicken drumsticks: ', x2.varValue)
    print('Corn cobs: ', x3.varValue)
else:
    print('The model is infeasible')
