
import gurobipy as gp

# Create a new model
model = gp.Model("nutrition_optimization")

# Create variables
fat = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")  # Grams of fat
b12 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b12") # Milligrams of vitamin B12

# Set objective function
model.setObjective(5.14 * fat + 5.3 * b12, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(17 * fat + 17 * b12 >= 16, "cognitive_min")
model.addConstr(7 * fat + 17 * b12 >= 48, "cardio_min")
model.addConstr(-4 * fat + 10 * b12 >= 0, "fat_b12_ratio")
model.addConstr(17 * fat + 17 * b12 <= 38, "cognitive_max")
model.addConstr(7 * fat + 17 * b12 <= 104, "cardio_max")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Grams of fat: {fat.x}")
    print(f"Milligrams of vitamin B12: {b12.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

