
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="grams_of_fat")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B12")

# Set the objective function
m.setObjective(5.14*x0 + 5.3*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*x0 + 17*x1 >= 16, "cognitive_performance_min")
m.addConstr(7*x0 + 17*x1 >= 48, "cardiovascular_support_min")
m.addConstr(-4*x0 + 10*x1 >= 0, "additional_constraint")
m.addConstr(17*x0 + 17*x1 <= 38, "cognitive_performance_max")
m.addConstr(7*x0 + 17*x1 <= 104, "cardiovascular_support_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"grams_of_fat: {x0.x}")
    print(f"milligrams_of_vitamin_B12: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
