
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x1 = model.addVar(name='grams_of_fat', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = model.addVar(name='milligrams_of_vitamin_B12', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
model.setObjective(5.14 * x1 + 5.3 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(17 <= 52, name='cognitive_performance_fat') # Not needed as direct limit
model.addConstr(7 * x1 <= 176, name='cardiovascular_support_fat')
model.addConstr(17 * x2 <= 52, name='cognitive_performance_vitamin')
model.addConstr(17 * x2 <= 176, name='cardiovascular_support_vitamin')
model.addConstr(17 * x1 + 17 * x2 >= 16, name='min_cognitive_performance')
model.addConstr(7 * x1 + 17 * x2 >= 48, name='min_cardiovascular_support')
model.addConstr(-4 * x1 + 10 * x2 >= 0, name='vitamin_fat_relation')
model.addConstr(17 * x1 + 17 * x2 <= 38, name='max_cognitive_performance')
model.addConstr(7 * x1 + 17 * x2 <= 104, name='max_cardiovascular_support')

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Grams of fat: ', x1.varValue)
    print('Milligrams of vitamin B12: ', x2.varValue)
else:
    print('No optimal solution found')
