
import gurobipy as gp

# Create a new model
m = gp.Model("plant_optimization")

# Create variables
bean_stalks = m.addVar(vtype=gp.GRB.INTEGER, name="bean_stalks")
strawberry_bushes = m.addVar(vtype=gp.GRB.INTEGER, name="strawberry_bushes")
agave = m.addVar(vtype=gp.GRB.INTEGER, name="agave")
tulips = m.addVar(vtype=gp.GRB.INTEGER, name="tulips")

# Set objective function
m.setObjective(1 * bean_stalks + 2 * strawberry_bushes + 7 * agave + 2 * tulips, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * strawberry_bushes + 2 * agave >= 80)
m.addConstr(6 * strawberry_bushes + 21 * tulips >= 53)
m.addConstr(15 * bean_stalks + 1 * strawberry_bushes >= 31)
m.addConstr(1 * strawberry_bushes + 3 * agave + 16 * tulips >= 58)
m.addConstr(13 * bean_stalks + 11 * agave + 21 * tulips >= 51) # Combined resilience constraints
m.addConstr(13 * bean_stalks + 17 * strawberry_bushes + 21 * tulips >= 51) # Combined resilience constraints
m.addConstr(10 * bean_stalks + 8 * agave + 23 * tulips >= 27) # Combined beauty rating
m.addConstr(10 * bean_stalks + 4 * strawberry_bushes + 23 * tulips >= 27) # Combined beauty rating
m.addConstr(2 * agave + 21 * tulips <= 175)
m.addConstr(6 * bean_stalks + 2 * agave <= 299)
m.addConstr(6 * strawberry_bushes + 2 * agave <= 142)
m.addConstr(6 * bean_stalks + 6 * strawberry_bushes + 2 * agave + 21 * tulips <= 142)
m.addConstr(1 * strawberry_bushes + 16 * tulips <= 173)
m.addConstr(15 * bean_stalks + 16 * tulips <= 84)
m.addConstr(15 * bean_stalks + 3 * agave <= 72)
m.addConstr(3 * agave + 16 * tulips <= 186)
m.addConstr(15 * bean_stalks + 1 * strawberry_bushes + 3 * agave <= 109)
m.addConstr(15 * bean_stalks + 1 * strawberry_bushes + 16 * tulips <= 196)
m.addConstr(15 * bean_stalks + 1 * strawberry_bushes + 3 * agave + 16 * tulips <= 196)
m.addConstr(13 * bean_stalks + 21 * tulips <= 162)
m.addConstr(17 * strawberry_bushes + 11 * agave <= 62)
m.addConstr(13 * bean_stalks + 11 * agave <= 150)
m.addConstr(13 * bean_stalks + 17 * strawberry_bushes + 11 * agave <= 160)
m.addConstr(13 * bean_stalks + 17 * strawberry_bushes + 11 * agave + 21 * tulips <= 160)
m.addConstr(4 * strawberry_bushes + 23 * tulips <= 136)
m.addConstr(10 * bean_stalks + 8 * agave <= 126)
m.addConstr(10 * bean_stalks + 23 * tulips <= 52)
m.addConstr(10 * bean_stalks + 4 * strawberry_bushes + 23 * tulips <= 150)
m.addConstr(10 * bean_stalks + 8 * agave + 23 * tulips <= 88)
m.addConstr(10 * bean_stalks + 4 * strawberry_bushes + 8 * agave + 23 * tulips <= 88)
m.addConstr(6 * bean_stalks + 6 * strawberry_bushes + 2 * agave + 21 * tulips <= 327)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

