
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    peggy_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")
    laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")


    # Set objective function
    model.setObjective(9 * peggy_hours + 6 * laura_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(14.74 * peggy_hours + 7.16 * laura_hours >= 35, "dollar_cost_min")
    model.addConstr(11.02 * peggy_hours + 19.32 * laura_hours >= 51, "quality_rating_min")
    model.addConstr(-6 * peggy_hours + 9 * laura_hours >= 0, "peggy_laura_ratio")
    model.addConstr(14.74 * peggy_hours + 7.16 * laura_hours <= 98, "dollar_cost_max")
    model.addConstr(11.02 * peggy_hours + 19.32 * laura_hours <= 119, "quality_rating_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Peggy: {peggy_hours.x}")
        print(f"Hours worked by Laura: {laura_hours.x}")
        print(f"Objective Value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

