
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Peggy", lb=0)  # hours worked by Peggy
x2 = m.addVar(name="hours_worked_by_Laura", lb=0)  # hours worked by Laura

# Define the objective function
m.setObjective(9 * x1 + 6 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(14.74 * x1 + 7.16 * x2 >= 35, name="total_dollar_cost")
m.addConstr(11.02 * x1 + 19.32 * x2 >= 51, name="total_work_quality_rating")
m.addConstr(-6 * x1 + 9 * x2 >= 0, name="work_quality_rating_constraint")
m.addConstr(14.74 * x1 + 7.16 * x2 <= 98, name="total_dollar_cost_upper_bound")
m.addConstr(11.02 * x1 + 19.32 * x2 <= 119, name="total_work_quality_rating_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Peggy: {x1.varValue}")
    print(f"Hours worked by Laura: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
