
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("minimize_hours")

    # Create variables
    laura_hours = m.addVar(vtype=gp.GRB.INTEGER, name="laura_hours")  # Integer constraint for Laura
    peggy_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy_hours")

    # Set objective function
    m.setObjective(9 * laura_hours + 6 * peggy_hours, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14.34 * laura_hours + 1.9 * peggy_hours >= 47, "productivity")
    m.addConstr(6.17 * laura_hours + 4.28 * peggy_hours >= 34, "quality")
    m.addConstr(5.43 * laura_hours + 6.99 * peggy_hours >= 44, "cost_min")
    m.addConstr(2 * laura_hours - peggy_hours >= 0, "laura_peggy_relation")
    m.addConstr(14.34 * laura_hours + 1.9 * peggy_hours <= 73, "productivity_max")
    m.addConstr(6.17 * laura_hours + 4.28 * peggy_hours <= 100, "quality_max")
    m.addConstr(5.43 * laura_hours + 6.99 * peggy_hours <= 82, "cost_max")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
