
from gurobipy import *

# Create a model
m = Model("Optimization Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Laura")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Peggy")

# Set objective function
m.setObjective(9*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(14.34*x1 + 1.9*x2 >= 47, "productivity_rating")
m.addConstr(6.17*x1 + 4.28*x2 >= 34, "work_quality_rating")
m.addConstr(5.43*x1 + 6.99*x2 >= 44, "dollar_cost_per_hour")
m.addConstr(2*x1 - x2 >= 0, "hours_worked_constraint")
m.addConstr(14.34*x1 + 1.9*x2 <= 73, "productivity_rating_upper_bound")
m.addConstr(6.17*x1 + 4.28*x2 <= 100, "work_quality_rating_upper_bound")
m.addConstr(5.43*x1 + 6.99*x2 <= 82, "dollar_cost_per_hour_upper_bound")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Laura:", x1.x)
    print("Hours worked by Peggy:", x2.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found")
